<?php



class SearchController extends SearchControllerCore

{



public function initContent()

	{

		$query = urldecode(Tools::getValue('q'));

		if ($this->ajax_search)

		{

			self::$link = new Link();

			$image = new Image();

			$searchResults = Search::find((int)(Tools::getValue('id_lang')), $query, 1, 10, 'position', 'desc', true);

			foreach ($searchResults as &$product){

			$imageID = $image->getCover($product['id_product']);

        	$imgLink = $this->context->link->getImageLink($product['prewrite'], (int)$product['id_product'].'-'.$imageID['id_image'], 'small_default');

			

			$product['product_link'] = $this->context->link->getProductLink($product['id_product'], $product['prewrite'], $product['crewrite']);

			$product['search_imgl'] = $imgLink;

			}

			die(Tools::jsonEncode($searchResults));

		}

		

		if ($this->instant_search && !is_array($query))

		{

			$this->productSort();

			$this->n = abs((int)(Tools::getValue('n', Configuration::get('PS_PRODUCTS_PER_PAGE'))));

			$this->p = abs((int)(Tools::getValue('p', 1)));

			$search = Search::find($this->context->language->id, $query, 1, 10, 'position', 'desc');

			Hook::exec('actionSearch', array('expr' => $query, 'total' => $search['total']));

			$nbProducts = $search['total'];

			$this->pagination($nbProducts);

			$this->context->smarty->assign(array(

				'products' => $search['result'], // DEPRECATED (since to 1.4), not use this: conflict with block_cart module

				'search_products' => $search['result'],

				'nbProducts' => $search['total'],

				'search_query' => $query,

				'instant_search' => $this->instant_search,

				'homeSize' => Image::getSize('home_default')));

		}

		else if (($query = Tools::getValue('search_query', Tools::getValue('ref'))) && !is_array($query) || Tools::getValue('category')) 

		{

			if(!$query)$query = Tools::getValue('catName');

			$cat = Tools::getValue('category');

			$this->productSort();

			$this->n = abs((int)(Tools::getValue('n', Configuration::get('PS_PRODUCTS_PER_PAGE'))));

			$this->p = abs((int)(Tools::getValue('p', 1)));

			$search = Search::find($this->context->language->id, $query, $this->p, $this->n, $this->orderBy, $this->orderWay, $cat);

			Hook::exec('actionSearch', array('expr' => $query, 'total' => $search['total']));

			$nbProducts = $search['total'];

			$this->pagination($nbProducts);

			$this->context->smarty->assign(array(

				'products' => $search['result'], // DEPRECATED (since to 1.4), not use this: conflict with block_cart module

				'search_products' => $search['result'],

				'nbProducts' => $search['total'],

				'search_query' => $query,

				'homeSize' => Image::getSize('home_default')));

		}

		else if (($tag = urldecode(Tools::getValue('tag'))) && !is_array($tag))

		{

			$nbProducts = (int)(Search::searchTag($this->context->language->id, $tag, true));

			$this->pagination($nbProducts);

			$this->productSort();

			$result = Search::searchTag($this->context->language->id, $tag, false, $this->p, $this->n, $this->orderBy, $this->orderWay);

			Hook::exec('actionSearch', array('expr' => $tag, 'total' => count($result)));

			$this->context->smarty->assign(array(

				'search_tag' => $tag,

				'products' => $result, // DEPRECATED (since to 1.4), not use this: conflict with block_cart module

				'search_products' => $result,

				'nbProducts' => $nbProducts,

				'homeSize' => Image::getSize('home_default')));

		}

		else

		{

			$this->context->smarty->assign(array(

				'products' => array(),

				'search_products' => array(),

				'pages_nb' => 1,

				'nbProducts' => 0));

		}

    

               $this->context->smarty->assign('add_prod_display', Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'));



		$this->setTemplate(_PS_THEME_DIR_.'search.tpl');

		

		parent::initContent();

		

	}

	



}



